﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="Select2Ejemplos.Default" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Ejemplos con Select2</title>
    <link href="css/bootstrap.min.css" rel="stylesheet" />
    <link href="css/select2.css" rel="stylesheet" />
    <link href="css/select2-bootstrap.css" rel="stylesheet" />
</head>
<body>
    <form id="form1" runat="server">
        <div class="container">
            <hr />
            <select id="ddlCiudades" class="form-control">
                <option></option>
                <option value="LI">Lima</option>
                <option value="PI">Piura</option>
                <option value="TRU">Trujillo</option>
                <option value="CHI">Chiclayo</option>
                <option>Tacna</option>
            </select>
        </div>
    </form>
    <script src="/scripts/jquery.js"></script>
    <script src="/scripts/select2.min.js"></script>
    <script src="/scripts/select2_locale_es.js"></script>
    <script>
        $(document).ready(function () {
            $("#ddlCiudades").select2({
                placeholder: "Seleccione una cuidad...",
                allowClear: true,
                //minimumInputLength: 3,
                formatResult: format,
                formatSelection: format,
                escapeMarkup: function (m) { return m; }
            });
        });

        function format(ciudad) {
            //alert('ID:' + ciudad.id + ' - Nombre:' + ciudad.text );
            return '<span style="color:red;"><b>' + ciudad.id + '</b></span>: ' + ciudad.text;
            
        }
    </script>
</body>

</html>
